/*
 * PushInfo.h
 *
 * Created 8/24/2009 By Johnny Huynh
 *
 * Version 00.00.01 8/24/2009
 *
 * Copyright Information:
 * All content copyright  2009 Johnny Huynh. All rights reserved.
 */
 
 /**
  * Only CharacterObject type Objects can be pushed. Make sure to supply a 
  * CharacterObject type when creating an ActionTask or EffectTask using
  * a PushInfo.
  */
 
 #ifndef PUSH_INFO_H
 #define PUSH_INFO_H
 
 template <typename T> class PushInfo;
 
 #include "global.h"
 
 #include "MoveInfo.h"
 #include "StunInfo.h"
 #include "pointerTo.h"
 #include "CharacterObject.h"
 
 /**
  * Class specification for PushInfo
  */
 template <typename T>
 class PushInfo : public MoveInfo<T>, public StunInfo<T>
 {
 // Data Members
 private:
    
 // Local Functions
 public:
    PushInfo( const double stun_duration, const MovementInfoCollection<T>& movement_info_collection );
    PushInfo( const PushInfo<T>& push_info );
    virtual ~PushInfo();
    inline PushInfo<T>& operator=( const PushInfo<T>& push_info );
    virtual inline void split_tasks( ActionTask<T>* action_task_Ptr, AsyncTaskManager* task_mgr_Ptr );
 
 // Private Functions
 private:
    
 // Friend Functions
 public:
    
 };
 
 /** LOCAL FUNCTIONS **/
 
 /**
  * Constructor
  */
 template <typename T>
 PushInfo<T>::PushInfo( const double stun_duration,
                        const MovementInfoCollection<T>& movement_info_collection )
             : MoveInfo<T>( movement_info_collection ),
               StunInfo<T>( stun_duration )
 {
    
 }
 
 /**
  * Copy Constructor
  */
 template <typename T>
 PushInfo<T>::PushInfo( const PushInfo<T>& push_info )
             : MoveInfo<T>( push_info ),
               StunInfo<T>( push_info )
 {
    
 }
 
 /**
  * Destructor
  */
 template <typename T>
 PushInfo<T>::~PushInfo()
 {
    
 }
 
 /**
  * operator=() copies the content of the specified PushInfo to this PushInfo.
  *
  * @param (const PushInfo<T>&) push_info
  * @return PushInfo<T>&
  */
 template <typename T>
 inline PushInfo<T>& PushInfo<T>::operator=( const PushInfo<T>& push_info )
 {
    MoveInfo<T>::operator=( push_info );
    StunInfo<T>::operator=( push_info );
    
    return *this;
 }
 
 /**
  * split_tasks() either assigns the specified task to the specified 
  * task manager or splits up the task into multiple tasks before 
  * assigning the tasks to the specified task manager.
  *
  * @param (ActionTask<T>*) action_task_Ptr
  * @param (AsyncTaskManager*) task_mgr_Ptr
  */
 template <typename T>
 inline void PushInfo<T>::split_tasks( ActionTask<T>* action_task_Ptr, AsyncTaskManager* task_mgr_Ptr )
 {
    nassertv( action_task_Ptr != NULL );
    nassertv( task_mgr_Ptr != NULL );
    
    StunInfo<T>::split_tasks( action_task_Ptr, task_mgr_Ptr );
    MoveInfo<T>::split_tasks( action_task_Ptr, task_mgr_Ptr );
 }
 
 /** FRIEND FUNCTIONS **/
 
 #endif // PUSH_INFO_H